# Sistema de Pessoas Desaparecidas

Um sistema web em PHP puro para cadastro e exibição de pessoas desaparecidas, com área administrativa e formulário de contato para visitantes.

## 🎯 Funcionalidades

### Área Pública
- **Página inicial** com cards de pessoas desaparecidas
- **Exibição de informações**: foto, nome, idade, data de desaparecimento, local e descrição
- **Modal de contato**: visitantes podem compartilhar informações sobre pessoas desaparecidas
- **Design responsivo** com Bootstrap 5 e Tailwind CSS

### Área Administrativa
- **Login seguro** com autenticação de admin
- **Dashboard** com estatísticas (total de pessoas e contatos)
- **Gerenciamento de pessoas**: criar, editar e deletar registros
- **Upload de fotos** para cada pessoa
- **Visualização de contatos** recebidos dos visitantes
- **Logout** seguro

## 📁 Estrutura do Projeto

```
pessoas-desaparecidas/
├── public/
│   └── index.php              # Página pública com cards
├── admin/
│   ├── login.php              # Login do admin
│   ├── index.php              # Dashboard
│   ├── pessoas.php            # Gerenciar pessoas
│   ├── contatos.php           # Visualizar contatos
│   └── logout.php             # Logout
├── includes/
│   ├── config.php             # Configuração do banco de dados
│   ├── auth.php               # Autenticação
│   └── functions.php          # Funções auxiliares
├── assets/
│   └── images/                # Pasta para fotos das pessoas
├── database/
│   └── pessoas_desaparecidas.db  # Banco de dados SQLite
└── README.md                  # Este arquivo
```

## 🚀 Como Usar

### Pré-requisitos
- PHP 7.4 ou superior
- Suporte a SQLite (geralmente incluído no PHP)
- Servidor web (Apache, Nginx, etc.)

### Instalação

1. **Clonar ou extrair o projeto**
   ```bash
   cd /home/ubuntu/pessoas-desaparecidas
   ```

2. **Criar pasta para imagens** (se não existir)
   ```bash
   mkdir -p assets/images
   chmod 755 assets/images
   ```

3. **Iniciar servidor PHP** (para desenvolvimento)
   ```bash
   php -S localhost:8000 -t public/
   ```

4. **Acessar no navegador**
   - Página pública: `http://localhost:8000/`
   - Admin: `http://localhost:8000/../admin/login.php`

### Credenciais Padrão

**Login Admin:**
- **Usuário:** `admin`
- **Senha:** `admin123`

⚠️ **Importante:** Altere a senha padrão após o primeiro acesso!

## 📝 Funcionalidades Detalhadas

### Página Pública (`/public/index.php`)

A página inicial exibe:
- Cards com informações de pessoas desaparecidas
- Foto, nome, idade, data e local de desaparecimento
- Descrição detalhada
- Botão "Quero Ajudar" que abre um modal

**Modal de Contato:**
- Campo para nome do visitante
- Email (obrigatório)
- Telefone (opcional)
- Mensagem com informações
- Dados são salvos no banco de dados

### Área Administrativa

#### Dashboard (`/admin/index.php`)
- Estatísticas gerais
- Atalhos para ações rápidas
- Lista das pessoas adicionadas recentemente

#### Gerenciar Pessoas (`/admin/pessoas.php`)
- **Listar:** visualizar todas as pessoas cadastradas
- **Criar:** adicionar nova pessoa com:
  - Nome (obrigatório)
  - Idade
  - Descrição
  - Data de desaparecimento
  - Local de desaparecimento
  - Foto (upload)
- **Editar:** modificar dados de pessoa existente
- **Deletar:** remover pessoa do sistema

#### Contatos (`/admin/contatos.php`)
- Visualizar todas as mensagens recebidas
- Informações do visitante (nome, email, telefone)
- Mensagem compartilhada
- Data e hora do contato
- Pessoa a qual a mensagem se refere

## 🗄️ Banco de Dados

O sistema usa **SQLite** com as seguintes tabelas:

### Tabela: `admins`
```sql
- id (INTEGER PRIMARY KEY)
- username (TEXT UNIQUE)
- password (TEXT - hash bcrypt)
- created_at (DATETIME)
```

### Tabela: `pessoas_desaparecidas`
```sql
- id (INTEGER PRIMARY KEY)
- nome (TEXT)
- idade (INTEGER)
- descricao (TEXT)
- foto_path (TEXT)
- data_desaparecimento (DATE)
- local_desaparecimento (TEXT)
- status (TEXT - 'ativo' ou 'inativo')
- created_at (DATETIME)
- updated_at (DATETIME)
```

### Tabela: `contatos`
```sql
- id (INTEGER PRIMARY KEY)
- pessoa_id (INTEGER - FK)
- nome (TEXT)
- email (TEXT)
- telefone (TEXT)
- mensagem (TEXT)
- created_at (DATETIME)
```

## 🔒 Segurança

- **Senhas:** Armazenadas com hash bcrypt
- **Sanitização:** Todas as entradas são sanitizadas com `htmlspecialchars()`
- **Sessões:** Autenticação baseada em sessão PHP
- **Validação:** Validação de entrada no servidor
- **Upload de arquivos:** Validação de tipo e tamanho

## 🎨 Design

- **Bootstrap 5:** Framework CSS para componentes responsivos
- **Tailwind CSS:** Utilitários CSS para customização
- **Font Awesome:** Ícones
- **Gradientes:** Cores vibrantes com gradientes roxo/azul
- **Responsivo:** Funciona em desktop, tablet e mobile

## 📱 Responsividade

O sistema é totalmente responsivo:
- **Desktop:** Layout em grid de 3 colunas
- **Tablet:** Layout em grid de 2 colunas
- **Mobile:** Layout em coluna única

## 🔄 Fluxo de Uso

### Para Visitante
1. Acessa a página pública
2. Visualiza cards de pessoas desaparecidas
3. Clica em "Quero Ajudar"
4. Preenche formulário com informações
5. Envia mensagem

### Para Admin
1. Acessa `/admin/login.php`
2. Faz login com credenciais
3. Acessa dashboard
4. Gerencia pessoas (criar, editar, deletar)
5. Visualiza contatos recebidos
6. Faz logout

## 🛠️ Customização

### Alterar Cores
Edite o arquivo `public/index.php` e `admin/login.php`:
```css
background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
```

### Alterar Credenciais Admin
Edite `includes/config.php` na função `initializeDatabase()`:
```php
VALUES (1, 'seu_usuario', '" . password_hash('sua_senha', PASSWORD_BCRYPT) . "')
```

### Adicionar Mais Campos
Edite `includes/config.php` para adicionar colunas na tabela `pessoas_desaparecidas`.

## 📞 Suporte

Para dúvidas ou problemas:
1. Verifique se o PHP está instalado corretamente
2. Confirme que a pasta `assets/images` tem permissão de escrita
3. Verifique os logs do servidor web
4. Teste o banco de dados SQLite

## 📄 Licença

Este projeto é fornecido como está, sem garantias.

## 🎓 Tecnologias Utilizadas

- **PHP 7.4+**
- **SQLite**
- **Bootstrap 5**
- **Tailwind CSS 4**
- **Font Awesome 6**
- **JavaScript (Vanilla)**

---

**Desenvolvido com ❤️ para ajudar a encontrar pessoas desaparecidas.**
