<?php
require_once __DIR__ . '/../includes/config.php';
require_once __DIR__ . '/../includes/auth.php';
require_once __DIR__ . '/../includes/functions.php';

requireAdminLogin();

$db = getDB();
$stmt = $db->query('
    SELECT c.*, p.nome as pessoa_nome 
    FROM contatos c
    JOIN pessoas_desaparecidas p ON c.pessoa_id = p.id
    ORDER BY c.created_at DESC
');
$contatos = $stmt->fetchAll(PDO::FETCH_ASSOC);
?>
<!DOCTYPE html>
<html lang="pt-BR">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Contatos - Admin</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <script src="https://cdn.tailwindcss.com"></script>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    <style>
        body {
            background-color: #f8f9fa;
        }
        .sidebar {
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            min-height: 100vh;
            color: white;
            padding: 20px;
        }
        .sidebar a {
            color: white;
            text-decoration: none;
            display: block;
            padding: 10px 15px;
            margin: 5px 0;
            border-radius: 5px;
            transition: 0.3s;
        }
        .sidebar a:hover {
            background: rgba(255, 255, 255, 0.2);
        }
        .sidebar a.active {
            background: rgba(255, 255, 255, 0.3);
            font-weight: bold;
        }
        .main-content {
            padding: 30px;
        }
        .card {
            border: none;
            box-shadow: 0 2px 10px rgba(0, 0, 0, 0.1);
            margin-bottom: 20px;
        }
        .card-header {
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            color: white;
            border: none;
            padding: 15px 20px;
        }
        .contact-card {
            border-left: 4px solid #667eea;
            padding: 15px;
            margin-bottom: 15px;
            background: white;
            border-radius: 5px;
            box-shadow: 0 2px 5px rgba(0, 0, 0, 0.1);
        }
        .contact-card h6 {
            color: #667eea;
            font-weight: bold;
            margin-bottom: 10px;
        }
        .contact-card p {
            margin: 5px 0;
            font-size: 0.95rem;
        }
        .contact-card .label {
            color: #666;
            font-weight: bold;
            font-size: 0.85rem;
        }
    </style>
</head>
<body>
    <div class="container-fluid">
        <div class="row">
            <!-- Sidebar -->
            <div class="col-md-3 sidebar">
                <h3 class="mb-4">
                    <i class="fas fa-shield-alt"></i> Admin Panel
                </h3>
                <a href="/admin/index.php">
                    <i class="fas fa-home"></i> Dashboard
                </a>
                <a href="/admin/pessoas.php">
                    <i class="fas fa-users"></i> Gerenciar Pessoas
                </a>
                <a href="/admin/contatos.php" class="active">
                    <i class="fas fa-envelope"></i> Contatos Recebidos
                </a>
                <hr style="border-color: rgba(255, 255, 255, 0.2);">
                <a href="/admin/logout.php">
                    <i class="fas fa-sign-out-alt"></i> Sair
                </a>
            </div>
            
            <!-- Main Content -->
            <div class="col-md-9 main-content">
                <div class="d-flex justify-content-between align-items-center mb-4">
                    <h1>Contatos Recebidos</h1>
                    <span class="badge bg-primary" style="font-size: 1rem;">
                        <?php echo count($contatos); ?> contatos
                    </span>
                </div>
                
                <div class="card">
                    <div class="card-header">
                        <h5 class="mb-0">Todas as Mensagens</h5>
                    </div>
                    <div class="card-body">
                        <?php if (empty($contatos)): ?>
                            <p class="text-muted text-center py-4">Nenhum contato recebido ainda.</p>
                        <?php else: ?>
                            <?php foreach ($contatos as $contato): ?>
                                <div class="contact-card">
                                    <h6>
                                        <i class="fas fa-user"></i> 
                                        <?php echo sanitize($contato['nome']); ?> 
                                        <span class="badge bg-info float-end">
                                            <?php echo sanitize($contato['pessoa_nome']); ?>
                                        </span>
                                    </h6>
                                    
                                    <div class="row">
                                        <div class="col-md-6">
                                            <p>
                                                <span class="label">Email:</span><br>
                                                <a href="mailto:<?php echo sanitize($contato['email']); ?>">
                                                    <?php echo sanitize($contato['email']); ?>
                                                </a>
                                            </p>
                                        </div>
                                        <div class="col-md-6">
                                            <p>
                                                <span class="label">Telefone:</span><br>
                                                <a href="tel:<?php echo sanitize($contato['telefone']); ?>">
                                                    <?php echo sanitize($contato['telefone']); ?>
                                                </a>
                                            </p>
                                        </div>
                                    </div>
                                    
                                    <p>
                                        <span class="label">Mensagem:</span><br>
                                        <?php echo nl2br(sanitize($contato['mensagem'])); ?>
                                    </p>
                                    
                                    <p class="text-muted small mb-0">
                                        <i class="fas fa-clock"></i> 
                                        <?php echo date('d/m/Y H:i', strtotime($contato['created_at'])); ?>
                                    </p>
                                </div>
                            <?php endforeach; ?>
                        <?php endif; ?>
                    </div>
                </div>
            </div>
        </div>
    </div>
    
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>
