<?php
session_start();

// Verificar se o admin está logado
function isAdminLoggedIn() {
    return isset($_SESSION['admin_id']) && isset($_SESSION['admin_username']);
}

// Fazer login do admin
function loginAdmin($username, $password) {
    $db = getDB();

    $stmt = $db->prepare("SELECT id, username, password FROM admins WHERE username = ?");
    $stmt->execute([$username]);
    $admin = $stmt->fetch(PDO::FETCH_ASSOC);

    if ($admin && password_verify($password, $admin['password'])) {

        // Evitar fixation attack
        session_regenerate_id(true);

        $_SESSION['admin_id'] = $admin['id'];
        $_SESSION['admin_username'] = $admin['username'];
        return true;
    }

    return false;
}

// Fazer logout do admin
function logoutAdmin() {
    session_unset();
    session_destroy();
    header('Location: /admin/login.php');
    exit;
}

// Bloquear páginas sem login
function requireAdminLogin() {
    if (!isAdminLoggedIn()) {
        header('Location: /admin/login.php');
        exit;
    }
}
?>
