<?php
require_once __DIR__ . '/../includes/config.php';
require_once __DIR__ . '/../includes/functions.php';

$pessoas = getAllPessoas();
$success = '';
$error = '';

// Processar formulário de contato
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['submit_contato'])) {
    $pessoa_id = intval($_POST['pessoa_id'] ?? 0);
    $nome = sanitize($_POST['nome'] ?? '');
    $email = sanitize($_POST['email'] ?? '');
    $telefone = sanitize($_POST['telefone'] ?? '');
    $mensagem = sanitize($_POST['mensagem'] ?? '');
    
    if ($pessoa_id && $nome && $email && $mensagem) {
        if (createContato($pessoa_id, $nome, $email, $telefone, $mensagem)) {
            $success = 'Obrigado! Suas informações foram enviadas com sucesso.';
        } else {
            $error = 'Erro ao enviar informações. Tente novamente.';
        }
    } else {
        $error = 'Por favor, preencha todos os campos obrigatórios.';
    }
}
?>
<!DOCTYPE html>
<html lang="pt-BR">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Pessoas Desaparecidas - Ajude a Encontrar</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <script src="https://cdn.tailwindcss.com"></script>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    <style>
        body {
            background-color: #f8f9fa;
        }
        
        /* Header/Navbar */
        .navbar-custom {
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            box-shadow: 0 2px 10px rgba(0, 0, 0, 0.1);
        }
        
        .navbar-custom .navbar-brand {
            font-weight: bold;
            font-size: 1.5rem;
            color: white !important;
        }
        
        .navbar-custom .nav-link {
            color: white !important;
            margin: 0 10px;
            transition: 0.3s;
        }
        
        .navbar-custom .nav-link:hover {
            color: #e0e0e0 !important;
        }
        
        /* Hero Section */
        .hero {
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            color: white;
            padding: 60px 20px;
            text-align: center;
        }
        
        .hero h1 {
            font-size: 2.5rem;
            font-weight: bold;
            margin-bottom: 20px;
        }
        
        .hero p {
            font-size: 1.1rem;
            margin-bottom: 20px;
        }
        
        /* Cards */
        .pessoa-card {
            background: white;
            border-radius: 10px;
            overflow: hidden;
            box-shadow: 0 4px 15px rgba(0, 0, 0, 0.1);
            transition: transform 0.3s, box-shadow 0.3s;
            height: 100%;
            display: flex;
            flex-direction: column;
        }
        
        .pessoa-card:hover {
            transform: translateY(-5px);
            box-shadow: 0 8px 25px rgba(0, 0, 0, 0.15);
        }
        
        .pessoa-card-img {
            width: 100%;
            height: 250px;
            object-fit: cover;
            background-color: #e9ecef;
        }
        
        .pessoa-card-body {
            padding: 20px;
            flex-grow: 1;
            display: flex;
            flex-direction: column;
        }
        
        .pessoa-card-title {
            font-size: 1.3rem;
            font-weight: bold;
            color: #333;
            margin-bottom: 10px;
        }
        
        .pessoa-info {
            font-size: 0.95rem;
            color: #666;
            margin: 8px 0;
        }
        
        .pessoa-info strong {
            color: #667eea;
        }
        
        .pessoa-descricao {
            color: #555;
            font-size: 0.9rem;
            margin: 15px 0;
            line-height: 1.5;
            flex-grow: 1;
        }
        
        .btn-ajudar {
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            border: none;
            color: white;
            font-weight: bold;
            padding: 10px 20px;
            border-radius: 5px;
            transition: 0.3s;
            align-self: flex-start;
            margin-top: auto;
        }
        
        .btn-ajudar:hover {
            background: linear-gradient(135deg, #764ba2 0%, #667eea 100%);
            color: white;
            text-decoration: none;
        }
        
        /* Modal */
        .modal-content {
            border: none;
            box-shadow: 0 10px 40px rgba(0, 0, 0, 0.2);
        }
        
        .modal-header {
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            color: white;
            border: none;
        }
        
        .modal-header .btn-close {
            filter: invert(1);
        }
        
        .form-control:focus {
            border-color: #667eea;
            box-shadow: 0 0 0 0.2rem rgba(102, 126, 234, 0.25);
        }
        
        .btn-primary {
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            border: none;
        }
        
        .btn-primary:hover {
            background: linear-gradient(135deg, #764ba2 0%, #667eea 100%);
        }
        
        /* Alert */
        .alert {
            margin-bottom: 20px;
        }
        
        /* Empty State */
        .empty-state {
            text-align: center;
            padding: 60px 20px;
            color: #999;
        }
        
        .empty-state i {
            font-size: 3rem;
            margin-bottom: 20px;
            color: #ddd;
        }
        
        /* Footer */
        .footer {
            background: #333;
            color: white;
            text-align: center;
            padding: 20px;
            margin-top: 60px;
        }
    </style>
</head>
<body>
    <!-- Navbar -->
    <nav class="navbar navbar-expand-lg navbar-custom">
        <div class="container-lg">
            <a class="navbar-brand" href="/">
                <i class="fas fa-search"></i> Pessoas Desaparecidas
            </a>
            <button class="navbar-toggler" type="button" data-bs-toggle="collapse" data-bs-target="#navbarNav">
                <span class="navbar-toggler-icon"></span>
            </button>
            <div class="collapse navbar-collapse" id="navbarNav">
                <ul class="navbar-nav ms-auto">
                    <li class="nav-item">
                        <a class="nav-link" href="/">Início</a>
                    </li>
                    <li class="nav-item">
                        <a class="nav-link" href="/admin/login.php">Admin</a>
                    </li>
                </ul>
            </div>
        </div>
    </nav>
    
    <!-- Hero Section -->
    <div class="hero">
        <div class="container-lg">
            <h1>🔍 Ajude a Encontrar Pessoas Desaparecidas</h1>
            <p>Se você tem informações sobre alguém desaparecido, clique em "Quero Ajudar" e compartilhe conosco.</p>
        </div>
    </div>
    
    <!-- Main Content -->
    <div class="container-lg py-5">
        <?php if ($success): ?>
            <div class="alert alert-success alert-dismissible fade show" role="alert">
                <i class="fas fa-check-circle"></i> <?php echo $success; ?>
                <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
            </div>
        <?php endif; ?>
        
        <?php if ($error): ?>
            <div class="alert alert-danger alert-dismissible fade show" role="alert">
                <i class="fas fa-exclamation-circle"></i> <?php echo $error; ?>
                <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
            </div>
        <?php endif; ?>
        
        <?php if (empty($pessoas)): ?>
            <div class="empty-state">
                <i class="fas fa-inbox"></i>
                <h3>Nenhuma pessoa cadastrada</h3>
                <p>No momento, não há pessoas desaparecidas cadastradas no sistema.</p>
            </div>
        <?php else: ?>
            <div class="row g-4">
                <?php foreach ($pessoas as $pessoa): ?>
                    <div class="col-md-6 col-lg-4">
                        <div class="pessoa-card">
                            <?php if ($pessoa['foto_path']): ?>
                                <img src="<?php echo $pessoa['foto_path']; ?>" alt="<?php echo sanitize($pessoa['nome']); ?>" class="pessoa-card-img">
                            <?php else: ?>
                                <div class="pessoa-card-img d-flex align-items-center justify-content-center" style="background-color: #e9ecef;">
                                    <i class="fas fa-user" style="font-size: 3rem; color: #999;"></i>
                                </div>
                            <?php endif; ?>
                            
                            <div class="pessoa-card-body">
                                <h5 class="pessoa-card-title">
                                    <?php echo sanitize($pessoa['nome']); ?>
                                </h5>
                                
                                <div class="pessoa-info">
                                    <strong>Idade:</strong> <?php echo $pessoa['idade'] ?? 'Não informada'; ?> anos
                                </div>
                                
                                <div class="pessoa-info">
                                    <strong>Desaparecimento:</strong> <?php echo formatDate($pessoa['data_desaparecimento']); ?>
                                </div>
                                
                                <div class="pessoa-info">
                                    <strong>Local:</strong> <?php echo sanitize($pessoa['local_desaparecimento']); ?>
                                </div>
                                
                                <?php if ($pessoa['descricao']): ?>
                                    <div class="pessoa-descricao">
                                        <strong>Descrição:</strong><br>
                                        <?php echo nl2br(sanitize($pessoa['descricao'])); ?>
                                    </div>
                                <?php endif; ?>
                                
                                <button class="btn-ajudar" data-bs-toggle="modal" data-bs-target="#contatoModal" data-pessoa-id="<?php echo $pessoa['id']; ?>" data-pessoa-nome="<?php echo sanitize($pessoa['nome']); ?>">
                                    <i class="fas fa-heart"></i> Quero Ajudar
                                </button>
                            </div>
                        </div>
                    </div>
                <?php endforeach; ?>
            </div>
        <?php endif; ?>
    </div>
    
    <!-- Modal de Contato -->
    <div class="modal fade" id="contatoModal" tabindex="-1">
        <div class="modal-dialog modal-dialog-centered">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title">
                        <i class="fas fa-envelope"></i> Compartilhar Informações
                    </h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
                </div>
                <div class="modal-body">
                    <form id="contatoForm" method="POST">
                        <input type="hidden" name="submit_contato" value="1">
                        <input type="hidden" id="pessoa_id" name="pessoa_id" value="">
                        
                        <div class="alert alert-info" id="pessoaInfo">
                            <strong>Pessoa:</strong> <span id="pessoaNome"></span>
                        </div>
                        
                        <div class="mb-3">
                            <label for="nome" class="form-label">Seu Nome *</label>
                            <input type="text" class="form-control" id="nome" name="nome" required>
                        </div>
                        
                        <div class="mb-3">
                            <label for="email" class="form-label">Email *</label>
                            <input type="email" class="form-control" id="email" name="email" required>
                        </div>
                        
                        <div class="mb-3">
                            <label for="telefone" class="form-label">Telefone</label>
                            <input type="tel" class="form-control" id="telefone" name="telefone">
                        </div>
                        
                        <div class="mb-3">
                            <label for="mensagem" class="form-label">Sua Mensagem/Informação *</label>
                            <textarea class="form-control" id="mensagem" name="mensagem" rows="5" placeholder="Compartilhe qualquer informação que possa ajudar..." required></textarea>
                        </div>
                        
                        <p class="text-muted small">
                            <i class="fas fa-lock"></i> Seus dados serão mantidos em sigilo e usados apenas para contato.
                        </p>
                    </form>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cancelar</button>
                    <button type="submit" form="contatoForm" class="btn btn-primary">
                        <i class="fas fa-paper-plane"></i> Enviar Informações
                    </button>
                </div>
            </div>
        </div>
    </div>
    
    <!-- Footer -->
    <div class="footer">
        <p>&copy; 2024 Sistema de Pessoas Desaparecidas. Todos os direitos reservados.</p>
    </div>
    
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
    <script>
        // Atualizar modal com dados da pessoa
        const contatoModal = document.getElementById('contatoModal');
        contatoModal.addEventListener('show.bs.modal', function (event) {
            const button = event.relatedTarget;
            const pessoaId = button.getAttribute('data-pessoa-id');
            const pessoaNome = button.getAttribute('data-pessoa-nome');
            
            document.getElementById('pessoa_id').value = pessoaId;
            document.getElementById('pessoaNome').textContent = pessoaNome;
        });
        
        // Limpar formulário ao fechar modal
        contatoModal.addEventListener('hidden.bs.modal', function () {
            document.getElementById('contatoForm').reset();
        });
    </script>
</body>
</html>
