<?php
/**
 * Script para popular o banco de dados com dados de exemplo
 * Execute: php seed-data.php
 */

require_once __DIR__ . '/includes/config.php';
require_once __DIR__ . '/includes/functions.php';

echo "=== ADICIONANDO DADOS DE EXEMPLO ===\n\n";

$pessoas_exemplo = [
    [
        'nome' => 'João Silva Santos',
        'idade' => 28,
        'descricao' => 'Desaparecido desde 15 de novembro de 2024. Última vez visto usando camiseta azul e calça jeans. Qualquer informação, favor contatar.',
        'data_desaparecimento' => '2024-11-15',
        'local_desaparecimento' => 'São Paulo, SP - Região de Pinheiros'
    ],
    [
        'nome' => 'Maria Oliveira Costa',
        'idade' => 35,
        'descricao' => 'Desaparecida há 3 semanas. Sofre de diabetes. Saiu de casa para trabalhar e não retornou. Família muito preocupada.',
        'data_desaparecimento' => '2024-11-10',
        'local_desaparecimento' => 'Rio de Janeiro, RJ - Centro'
    ],
    [
        'nome' => 'Pedro Henrique Alves',
        'idade' => 16,
        'descricao' => 'Adolescente desaparecido. Tinha problemas na escola. Saiu de casa sem avisar ninguém. Qualquer informação é importante.',
        'data_desaparecimento' => '2024-11-20',
        'local_desaparecimento' => 'Belo Horizonte, MG'
    ],
    [
        'nome' => 'Francisca Mendes Rocha',
        'idade' => 67,
        'descricao' => 'Idosa desaparecida. Sofre de Alzheimer. Saiu de casa e não retornou. Pode estar desorientada. Muito importante encontrá-la.',
        'data_desaparecimento' => '2024-11-22',
        'local_desaparecimento' => 'Salvador, BA'
    ],
    [
        'nome' => 'Carlos Eduardo Martins',
        'idade' => 42,
        'descricao' => 'Homem desaparecido há 1 mês. Deixou família preocupada. Trabalha como eletricista. Qualquer pista é bem-vinda.',
        'data_desaparecimento' => '2024-10-28',
        'local_desaparecimento' => 'Curitiba, PR'
    ]
];

$count = 0;
foreach ($pessoas_exemplo as $pessoa) {
    $success = createPessoa(
        $pessoa['nome'],
        $pessoa['idade'],
        $pessoa['descricao'],
        null,
        $pessoa['data_desaparecimento'],
        $pessoa['local_desaparecimento']
    );
    
    if ($success) {
        echo "✓ Adicionado: {$pessoa['nome']}\n";
        $count++;
    } else {
        echo "✗ Erro ao adicionar: {$pessoa['nome']}\n";
    }
}

echo "\n=== RESUMO ===\n";
echo "Total de pessoas adicionadas: $count\n";
echo "\nAcesse o sistema em:\n";
echo "  - Página pública: http://localhost:8000/\n";
echo "  - Admin: http://localhost:8000/../admin/login.php\n";
echo "  - Credenciais: admin / admin123\n";
?>
