<?php
/**
 * Script de teste do sistema de pessoas desaparecidas
 */

require_once __DIR__ . '/includes/config.php';
require_once __DIR__ . '/includes/functions.php';

echo "=== TESTE DO SISTEMA DE PESSOAS DESAPARECIDAS ===\n\n";

// Teste 1: Banco de dados
echo "1. Testando banco de dados...\n";
try {
    $db = getDB();
    echo "   ✓ Conexão com banco de dados OK\n";
} catch (Exception $e) {
    echo "   ✗ Erro: " . $e->getMessage() . "\n";
    exit(1);
}

// Teste 2: Tabelas
echo "\n2. Verificando tabelas...\n";
$tables = ['admins', 'pessoas_desaparecidas', 'contatos'];
foreach ($tables as $table) {
    $stmt = $db->query("SELECT name FROM sqlite_master WHERE type='table' AND name='$table'");
    if ($stmt->fetch()) {
        echo "   ✓ Tabela '$table' existe\n";
    } else {
        echo "   ✗ Tabela '$table' não encontrada\n";
    }
}

// Teste 3: Admin padrão
echo "\n3. Verificando admin padrão...\n";
$stmt = $db->query("SELECT COUNT(*) as count FROM admins");
$result = $stmt->fetch(PDO::FETCH_ASSOC);
if ($result['count'] > 0) {
    echo "   ✓ Admin padrão criado\n";
} else {
    echo "   ✗ Admin padrão não encontrado\n";
}

// Teste 4: Criar pessoa de teste
echo "\n4. Testando criação de pessoa...\n";
$success = createPessoa(
    'João Silva',
    25,
    'Desaparecido desde 15 de novembro de 2024',
    null,
    '2024-11-15',
    'São Paulo, SP'
);
if ($success) {
    echo "   ✓ Pessoa criada com sucesso\n";
} else {
    echo "   ✗ Erro ao criar pessoa\n";
}

// Teste 5: Listar pessoas
echo "\n5. Testando listagem de pessoas...\n";
$pessoas = getAllPessoas();
echo "   ✓ Total de pessoas: " . count($pessoas) . "\n";
if (count($pessoas) > 0) {
    echo "   ✓ Primeira pessoa: " . sanitize($pessoas[0]['nome']) . "\n";
}

// Teste 6: Criar contato
echo "\n6. Testando criação de contato...\n";
if (count($pessoas) > 0) {
    $success = createContato(
        $pessoas[0]['id'],
        'Maria Santos',
        'maria@example.com',
        '11999999999',
        'Vi uma pessoa parecida no bairro de Pinheiros'
    );
    if ($success) {
        echo "   ✓ Contato criado com sucesso\n";
    } else {
        echo "   ✗ Erro ao criar contato\n";
    }
}

// Teste 7: Verificar estrutura de diretórios
echo "\n7. Verificando estrutura de diretórios...\n";
$dirs = [
    'public' => 'Página pública',
    'admin' => 'Área administrativa',
    'includes' => 'Arquivos de configuração',
    'assets/images' => 'Pasta de imagens',
    'database' => 'Banco de dados'
];

foreach ($dirs as $dir => $desc) {
    if (is_dir(__DIR__ . '/' . $dir)) {
        echo "   ✓ $desc ($dir)\n";
    } else {
        echo "   ✗ $desc ($dir) não encontrada\n";
    }
}

echo "\n=== TESTE CONCLUÍDO ===\n";
echo "\nAcesse o sistema em:\n";
echo "  - Página pública: http://localhost:8080/\n";
echo "  - Admin: http://localhost:8080/../admin/login.php\n";
echo "  - Credenciais: admin / admin123\n";
?>
